/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.lua.api.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.figuramc.figura.lua.LuaWhitelist;
import org.figuramc.figura.lua.NbtToLua;
import org.figuramc.figura.lua.ReadOnlyLuaTable;
import org.figuramc.figura.lua.api.world.ItemStackAPI;
import org.figuramc.figura.lua.api.world.WorldAPI;
import org.figuramc.figura.lua.docs.LuaFieldDoc;
import org.figuramc.figura.lua.docs.LuaMethodDoc;
import org.figuramc.figura.lua.docs.LuaMethodOverload;
import org.figuramc.figura.lua.docs.LuaTypeDoc;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.mixin.BlockBehaviourAccessor;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.LuaUtils;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

@LuaWhitelist
@LuaTypeDoc(name="BlockState", value="blockstate")
public class BlockStateAPI {
    public final BlockState blockState;
    private BlockPos pos;
    @LuaWhitelist
    @LuaFieldDoc(value="blockstate.id")
    public final String id;
    @LuaWhitelist
    @LuaFieldDoc(value="blockstate.properties")
    public final LuaTable properties;

    public BlockStateAPI(BlockState blockstate, BlockPos pos) {
        this.blockState = blockstate;
        this.pos = pos;
        this.id = BuiltInRegistries.BLOCK.getKey((Object)blockstate.getBlock()).toString();
        CompoundTag tag = NbtUtils.writeBlockState((BlockState)blockstate);
        this.properties = new ReadOnlyLuaTable((LuaValue)(tag.contains("Properties") ? NbtToLua.convert(tag.get("Properties")) : new LuaTable()));
    }

    protected BlockPos getBlockPos() {
        return this.pos == null ? BlockPos.ZERO : this.pos;
    }

    protected static List<List<FiguraVec3>> voxelShapeToTable(VoxelShape shape) {
        ArrayList<List<FiguraVec3>> shapes = new ArrayList<List<FiguraVec3>>();
        for (AABB aabb : shape.toAabbs()) {
            shapes.add(List.of(FiguraVec3.of(aabb.minX, aabb.minY, aabb.minZ), FiguraVec3.of(aabb.maxX, aabb.maxY, aabb.maxZ)));
        }
        return shapes;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_id")
    public String getID() {
        return this.id;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_properties")
    public LuaTable getProperties() {
        return this.properties;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_pos")
    public FiguraVec3 getPos() {
        return FiguraVec3.fromBlockPos(this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(overloads={@LuaMethodOverload(argumentTypes={FiguraVec3.class}, argumentNames={"pos"}), @LuaMethodOverload(argumentTypes={Double.class, Double.class, Double.class}, argumentNames={"x", "y", "z"})}, aliases={"pos"}, value="blockstate.set_pos")
    public BlockStateAPI setPos(Object x, Double y, Double z) {
        FiguraVec3 newPos = LuaUtils.parseVec3("setPos", x, y, z);
        this.pos = newPos.asBlockPos();
        return this;
    }

    @LuaWhitelist
    public BlockStateAPI pos(Object x, Double y, Double z) {
        return this.setPos(x, y, z);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.is_translucent")
    public boolean isTranslucent() {
        return this.blockState.propagatesSkylightDown((BlockGetter)WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_opacity")
    public int getOpacity() {
        return this.blockState.getLightBlock((BlockGetter)WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_map_color")
    public FiguraVec3 getMapColor() {
        return ColorUtils.intToRGB(this.blockState.getMapColor((BlockGetter)WorldAPI.getCurrentWorld(), (BlockPos)this.getBlockPos()).col);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.is_solid_block")
    public boolean isSolidBlock() {
        return this.blockState.isRedstoneConductor((BlockGetter)WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.is_full_cube")
    public boolean isFullCube() {
        return this.blockState.isCollisionShapeFullBlock((BlockGetter)WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.has_emissive_lighting")
    public boolean hasEmissiveLighting() {
        return this.blockState.emissiveRendering((BlockGetter)WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_hardness")
    public float getHardness() {
        return this.blockState.getDestroySpeed((BlockGetter)WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_comparator_output")
    public int getComparatorOutput() {
        return this.blockState.getAnalogOutputSignal(WorldAPI.getCurrentWorld(), this.getBlockPos());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.has_block_entity")
    public boolean hasBlockEntity() {
        return this.blockState.hasBlockEntity();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.is_opaque")
    public boolean isOpaque() {
        return this.blockState.canOcclude();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.emits_redstone_power")
    public boolean emitsRedstonePower() {
        return this.blockState.isSignalSource();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_luminance")
    public int getLuminance() {
        return this.blockState.getLightEmission();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_friction")
    public float getFriction() {
        return this.blockState.getBlock().getFriction();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_velocity_multiplier")
    public float getVelocityMultiplier() {
        return this.blockState.getBlock().getSpeedFactor();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_jump_velocity_multiplier")
    public float getJumpVelocityMultiplier() {
        return this.blockState.getBlock().getJumpFactor();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_blast_resistance")
    public float getBlastResistance() {
        return this.blockState.getBlock().getExplosionResistance();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.as_item")
    public ItemStackAPI asItem() {
        return ItemStackAPI.verify(this.blockState.getBlock().asItem().getDefaultInstance());
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_tags")
    public List<String> getTags() {
        ArrayList<String> list = new ArrayList<String>();
        Registry registry = WorldAPI.getCurrentWorld().registryAccess().registryOrThrow(Registries.BLOCK);
        Optional key = registry.getResourceKey((Object)this.blockState.getBlock());
        if (key.isEmpty()) {
            return list;
        }
        for (TagKey blockTagKey : registry.getHolderOrThrow((ResourceKey)key.get()).tags().toList()) {
            list.add(blockTagKey.location().toString());
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.has_collision")
    public boolean hasCollision() {
        return ((BlockBehaviourAccessor)this.blockState.getBlock()).hasCollision();
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_collision_shape")
    public List<List<FiguraVec3>> getCollisionShape() {
        return BlockStateAPI.voxelShapeToTable(this.blockState.getCollisionShape((BlockGetter)WorldAPI.getCurrentWorld(), this.getBlockPos()));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_outline_shape")
    public List<List<FiguraVec3>> getOutlineShape() {
        return BlockStateAPI.voxelShapeToTable(this.blockState.getShape((BlockGetter)WorldAPI.getCurrentWorld(), this.getBlockPos()));
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_sounds")
    public Map<String, Object> getSounds() {
        HashMap<String, Object> sounds = new HashMap<String, Object>();
        SoundType snd = this.blockState.getSoundType();
        sounds.put("pitch", Float.valueOf(snd.getPitch()));
        sounds.put("volume", Float.valueOf(snd.getVolume()));
        sounds.put("break", snd.getBreakSound().getLocation().toString());
        sounds.put("fall", snd.getFallSound().getLocation().toString());
        sounds.put("hit", snd.getHitSound().getLocation().toString());
        sounds.put("place", snd.getPlaceSound().getLocation().toString());
        sounds.put("step", snd.getStepSound().getLocation().toString());
        return sounds;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_fluid_tags")
    public List<String> getFluidTags() {
        ArrayList<String> list = new ArrayList<String>();
        for (TagKey fluidTagKey : this.blockState.getFluidState().getTags().toList()) {
            list.add(fluidTagKey.location().toString());
        }
        return list;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_entity_data")
    public LuaTable getEntityData() {
        BlockEntity entity = WorldAPI.getCurrentWorld().getBlockEntity(this.getBlockPos());
        if (entity != null) {
            ItemStack stack = new ItemStack((ItemLike)entity.getBlockState().getBlock().asItem());
            entity.saveToItem(stack, (HolderLookup.Provider)WorldAPI.getCurrentWorld().registryAccess());
            LuaTable componentTable = (LuaTable)NbtToLua.convert((Tag)NbtToLua.convertToNbt(stack.getComponents()));
            LuaTable entityTable = (LuaTable)NbtToLua.convert((Tag)entity.saveWithoutMetadata((HolderLookup.Provider)WorldAPI.getCurrentWorld().registryAccess()));
            LuaUtils.addLegacyNbtNames(componentTable, entityTable);
            return entityTable;
        }
        return null;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.to_state_string")
    public String toStateString() {
        BlockEntity entity = WorldAPI.getCurrentWorld().getBlockEntity(this.getBlockPos());
        CompoundTag tag = entity != null ? entity.saveWithoutMetadata((HolderLookup.Provider)WorldAPI.getCurrentWorld().registryAccess()) : new CompoundTag();
        return BlockStateParser.serialize((BlockState)this.blockState) + String.valueOf(tag);
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.get_textures")
    public HashMap<String, Set<String>> getTextures() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        RenderShape renderShape = this.blockState.getRenderShape();
        if (renderShape == RenderShape.MODEL) {
            BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
            BakedModel bakedModel = blockRenderer.getBlockModel(this.blockState);
            RandomSource randomSource = RandomSource.create();
            long seed = 42L;
            for (Direction direction : Direction.values()) {
                map.put(direction.name(), BlockStateAPI.getTexturesForFace(this.blockState, direction, randomSource, bakedModel, seed));
            }
            map.put("NONE", BlockStateAPI.getTexturesForFace(this.blockState, null, randomSource, bakedModel, seed));
            TextureAtlasSprite particle = blockRenderer.getBlockModelShaper().getParticleIcon(this.blockState);
            map.put("PARTICLE", Set.of(BlockStateAPI.getTextureName(particle)));
        } else if (renderShape == RenderShape.ENTITYBLOCK_ANIMATED) {
            map.put("PARTICLE", Set.of(BlockStateAPI.getTextureName(Minecraft.getInstance().getItemRenderer().getModel(this.blockState.getBlock().asItem().getDefaultInstance(), WorldAPI.getCurrentWorld(), null, 42).getParticleIcon())));
        }
        return map;
    }

    @LuaWhitelist
    @LuaMethodDoc(value="blockstate.is_air")
    public boolean isAir() {
        return this.blockState.isAir();
    }

    private static Set<String> getTexturesForFace(BlockState blockState, Direction direction, RandomSource randomSource, BakedModel bakedModel, long seed) {
        randomSource.setSeed(seed);
        List quads = bakedModel.getQuads(blockState, direction, randomSource);
        HashSet<String> textures = new HashSet<String>();
        for (BakedQuad quad : quads) {
            textures.add(BlockStateAPI.getTextureName(quad.getSprite()));
        }
        return textures;
    }

    private static String getTextureName(TextureAtlasSprite sprite) {
        ResourceLocation location = sprite.contents().name();
        return location.getNamespace() + ":textures/" + location.getPath();
    }

    @LuaWhitelist
    public boolean __eq(BlockStateAPI other) {
        return this.blockState.equals(other.blockState);
    }

    @LuaWhitelist
    public Object __index(String arg) {
        if (arg == null) {
            return null;
        }
        return switch (arg) {
            case "id" -> this.id;
            case "properties" -> this.properties;
            default -> null;
        };
    }

    public String toString() {
        return this.id + " (BlockState)";
    }
}

